/**
 * \file: util_trace_prc.c
 *
 * \version:
 *
 * Simplified interface for TTFis, which offers among others a printf
 * like function.
 *
 * \component: Utility library
 *
 * \author: Torsten Polle / ADIT.J /SWG / tpolle\jp.adit-jv.com
 *
 * \copyright: (c) 2003 - 2005 ADIT Corporation
 */

#include "trace_interface.h"

EXPORT U32 UTIL_TraceOut(U32 uwLen, U16 trClass, TR_tenTraceLevel trLevel,
                       const U8* p_ubTrData)
{
    return TR_core_uwTraceOut(uwLen, trClass, trLevel, (U8*)p_ubTrData);
}
EXPORT U32 UTIL_TraceBinOutput(U32 uwCompId, U32 uwSockId, U32 uwBufferLen,
									U8* p_ubDataBuffer)
{
    return TR_core_uwTraceBinOutput(uwCompId, uwSockId, uwBufferLen, 
										p_ubDataBuffer);
}
EXPORT BOOL UTIL_IsClassSelected(U16 trClass, TR_tenTraceLevel trLevel)
{
  /*@dhd3kor: Fix for SWGII-4648 (UTIL-Trace expects TRUE or FALSE from TR_core_bIsClassSelected() not an enum)*/
  return (TR_core_bIsClassSelected(trClass, trLevel) != FALSE); 
}

EXPORT BOOL UTIL_RegisterChannel(TR_tenTraceChan      chan_id,
                                 const TRACE_CALLBACK p_Func)
{
  return TR_chan_acess_bRegChan(chan_id,
                                (TRACE_CALLBACK)p_Func);
}

EXPORT BOOL UTIL_UnregisterChannel(TR_tenTraceChan      chan_id,
                                  const TRACE_CALLBACK p_Func)
{
  return TR_chan_acess_bUnRegChan(chan_id,
                                 (TRACE_CALLBACK)p_Func);
}
